@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.printfarmplan.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.printfarmplans.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label class="required" for="name">{{ trans('cruds.printfarmplan.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', '') }}" required>
                @if($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.printfarmplan.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="productline_id">{{ trans('cruds.printfarmplan.fields.productline') }}</label>
                <select class="form-control select2 {{ $errors->has('productline') ? 'is-invalid' : '' }}" name="productline_id" id="productline_id" required>
                    @foreach($productlines as $id => $entry)
                        <option value="{{ $id }}" {{ old('productline_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('productline'))
                    <span class="text-danger">{{ $errors->first('productline') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.printfarmplan.fields.productline_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="creator_id">{{ trans('cruds.printfarmplan.fields.creator') }}</label>
                <select class="form-control select2 {{ $errors->has('creator') ? 'is-invalid' : '' }}" name="creator_id" id="creator_id" required>
                    @foreach($creators as $id => $entry)
                        <option value="{{ $id }}" {{ old('creator_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('creator'))
                    <span class="text-danger">{{ $errors->first('creator') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.printfarmplan.fields.creator_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection