@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.show') }} {{ trans('cruds.idea.title') }}
    </div>

    <div class="card-body">
        <div class="form-group">
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.ideas.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
            <table class="table table-bordered table-striped">
                <tbody>
                    <tr>
                        <th>
                            {{ trans('cruds.idea.fields.id') }}
                        </th>
                        <td>
                            {{ $idea->id }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.idea.fields.name') }}
                        </th>
                        <td>
                            {{ $idea->name }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.idea.fields.productline') }}
                        </th>
                        <td>
                            {{ $idea->productline->name ?? '' }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.idea.fields.link') }}
                        </th>
                        <td>
                            {{ $idea->link }}
                        </td>
                    </tr>
                    <tr>
                        <th>
                            {{ trans('cruds.idea.fields.added') }}
                        </th>
                        <td>
                            {{ App\Models\Idea::ADDED_SELECT[$idea->added] ?? '' }}
                        </td>
                    </tr>
                </tbody>
            </table>
            <div class="form-group">
                <a class="btn btn-default" href="{{ route('admin.ideas.index') }}">
                    {{ trans('global.back_to_list') }}
                </a>
            </div>
        </div>
    </div>
</div>



@endsection