@extends('layouts.admin')
@section('content')

<div class="card">
    <div class="card-header">
        {{ trans('global.create') }} {{ trans('cruds.idea.title_singular') }}
    </div>

    <div class="card-body">
        <form method="POST" action="{{ route("admin.ideas.store") }}" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                <label class="required" for="name">{{ trans('cruds.idea.fields.name') }}</label>
                <input class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" type="text" name="name" id="name" value="{{ old('name', '') }}" required>
                @if($errors->has('name'))
                    <span class="text-danger">{{ $errors->first('name') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.idea.fields.name_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="productline_id">{{ trans('cruds.idea.fields.productline') }}</label>
                <select class="form-control select2 {{ $errors->has('productline') ? 'is-invalid' : '' }}" name="productline_id" id="productline_id" required>
                    @foreach($productlines as $id => $entry)
                        <option value="{{ $id }}" {{ old('productline_id') == $id ? 'selected' : '' }}>{{ $entry }}</option>
                    @endforeach
                </select>
                @if($errors->has('productline'))
                    <span class="text-danger">{{ $errors->first('productline') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.idea.fields.productline_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required" for="link">{{ trans('cruds.idea.fields.link') }}</label>
                <input class="form-control {{ $errors->has('link') ? 'is-invalid' : '' }}" type="text" name="link" id="link" value="{{ old('link', '') }}" required>
                @if($errors->has('link'))
                    <span class="text-danger">{{ $errors->first('link') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.idea.fields.link_helper') }}</span>
            </div>
            <div class="form-group">
                <label class="required">{{ trans('cruds.idea.fields.added') }}</label>
                <select class="form-control {{ $errors->has('added') ? 'is-invalid' : '' }}" name="added" id="added" required>
                    <option value disabled {{ old('added', null) === null ? 'selected' : '' }}>{{ trans('global.pleaseSelect') }}</option>
                    @foreach(App\Models\Idea::ADDED_SELECT as $key => $label)
                        <option value="{{ $key }}" {{ old('added', 'Notadded') === (string) $key ? 'selected' : '' }}>{{ $label }}</option>
                    @endforeach
                </select>
                @if($errors->has('added'))
                    <span class="text-danger">{{ $errors->first('added') }}</span>
                @endif
                <span class="help-block">{{ trans('cruds.idea.fields.added_helper') }}</span>
            </div>
            <div class="form-group">
                <button class="btn btn-danger" type="submit">
                    {{ trans('global.save') }}
                </button>
            </div>
        </form>
    </div>
</div>



@endsection