@extends('layouts.admin')
@section('content')
@can('creator_create')
    <div style="margin-bottom: 10px;" class="row">
        <div class="col-lg-12">
            <a class="btn btn-success" href="{{ route('admin.creators.create') }}">
                {{ trans('global.add') }} {{ trans('cruds.creator.title_singular') }}
            </a>
        </div>
    </div>
@endcan
<div class="card">
    <div class="card-header">
        {{ trans('cruds.creator.title_singular') }} {{ trans('global.list') }}
    </div>

    <div class="card-body">
        <div class="table-responsive">
            <table class=" table table-bordered table-striped table-hover datatable datatable-Creator">
                <thead>
                    <tr>
                        <th width="10">

                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.id') }}
                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.name') }}
                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.typeofmodels') }}
                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.platform') }}
                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.link') }}
                        </th>
                        <th>
                            {{ trans('cruds.creator.fields.subscribed') }}
                        </th>
                        <th>
                            &nbsp;
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($creators as $key => $creator)
                        <tr data-entry-id="{{ $creator->id }}">
                            <td>

                            </td>
                            <td>
                                {{ $creator->id ?? '' }}
                            </td>
                            <td>
                                {{ $creator->name ?? '' }}
                            </td>
                            <td>
                                {{ $creator->typeofmodels->name ?? '' }}
                            </td>
                            <td>
                                {{ $creator->platform->name ?? '' }}
                            </td>
                            <td>
                                {{ $creator->link ?? '' }}
                            </td>
                            <td>
                                {{ App\Models\Creator::SUBSCRIBED_SELECT[$creator->subscribed] ?? '' }}
                            </td>
                            <td>
                                @can('creator_show')
                                    <a class="btn btn-xs btn-primary" href="{{ route('admin.creators.show', $creator->id) }}">
                                        {{ trans('global.view') }}
                                    </a>
                                @endcan

                                @can('creator_edit')
                                    <a class="btn btn-xs btn-info" href="{{ route('admin.creators.edit', $creator->id) }}">
                                        {{ trans('global.edit') }}
                                    </a>
                                @endcan

                                @can('creator_delete')
                                    <form action="{{ route('admin.creators.destroy', $creator->id) }}" method="POST" onsubmit="return confirm('{{ trans('global.areYouSure') }}');" style="display: inline-block;">
                                        <input type="hidden" name="_method" value="DELETE">
                                        <input type="hidden" name="_token" value="{{ csrf_token() }}">
                                        <input type="submit" class="btn btn-xs btn-danger" value="{{ trans('global.delete') }}">
                                    </form>
                                @endcan

                            </td>

                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>



@endsection
@section('scripts')
@parent
<script>
    $(function () {
  let dtButtons = $.extend(true, [], $.fn.dataTable.defaults.buttons)
@can('creator_delete')
  let deleteButtonTrans = '{{ trans('global.datatables.delete') }}'
  let deleteButton = {
    text: deleteButtonTrans,
    url: "{{ route('admin.creators.massDestroy') }}",
    className: 'btn-danger',
    action: function (e, dt, node, config) {
      var ids = $.map(dt.rows({ selected: true }).nodes(), function (entry) {
          return $(entry).data('entry-id')
      });

      if (ids.length === 0) {
        alert('{{ trans('global.datatables.zero_selected') }}')

        return
      }

      if (confirm('{{ trans('global.areYouSure') }}')) {
        $.ajax({
          headers: {'x-csrf-token': _token},
          method: 'POST',
          url: config.url,
          data: { ids: ids, _method: 'DELETE' }})
          .done(function () { location.reload() })
      }
    }
  }
  dtButtons.push(deleteButton)
@endcan

  $.extend(true, $.fn.dataTable.defaults, {
    orderCellsTop: true,
    order: [[ 2, 'asc' ]],
    pageLength: 100,
  });
  let table = $('.datatable-Creator:not(.ajaxTable)').DataTable({ buttons: dtButtons })
  $('a[data-toggle="tab"]').on('shown.bs.tab click', function(e){
      $($.fn.dataTable.tables(true)).DataTable()
          .columns.adjust();
  });
  
})

</script>
@endsection