<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateEventsTable extends Migration
{
    public function up()
    {
        Schema::create('events', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('eventname');
            $table->date('date');
            $table->time('setuptime');
            $table->time('starttime');
            $table->time('packuptime');
            $table->longText('address');
            $table->decimal('cost', 15, 2);
            $table->string('gazebo')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }
}
