<?php

namespace App\Models;

use DateTimeInterface;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Idea extends Model
{
    use SoftDeletes, HasFactory;

    public $table = 'ideas';

    protected $dates = [
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    public const ADDED_SELECT = [
        'Notadded' => 'Not Added',
        'Added'    => 'Added',
    ];

    protected $fillable = [
        'name',
        'productline_id',
        'link',
        'added',
        'created_at',
        'updated_at',
        'deleted_at',
    ];

    protected function serializeDate(DateTimeInterface $date)
    {
        return $date->format('Y-m-d H:i:s');
    }

    public function productline()
    {
        return $this->belongsTo(Producttype::class, 'productline_id');
    }
}
