<?php

namespace App\Http\Requests;

use App\Models\Eventslog;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Http\Response;

class UpdateEventslogRequest extends FormRequest
{
    public function authorize()
    {
        return Gate::allows('eventslog_edit');
    }

    public function rules()
    {
        return [
            'eventname_id' => [
                'required',
                'integer',
            ],
            'cashtakings' => [
                'required',
            ],
            'cardtakings' => [
                'required',
            ],
        ];
    }
}
