<?php

namespace App\Http\Requests;

use App\Models\Producttype;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyProducttypeRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('producttype_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:producttypes,id',
        ];
    }
}
