<?php

namespace App\Http\Requests;

use App\Models\Printfarmplan;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyPrintfarmplanRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('printfarmplan_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:printfarmplans,id',
        ];
    }
}
