<?php

namespace App\Http\Requests;

use App\Models\Creator;
use Gate;
use Illuminate\Foundation\Http\FormRequest;
use Symfony\Component\HttpFoundation\Response;

class MassDestroyCreatorRequest extends FormRequest
{
    public function authorize()
    {
        abort_if(Gate::denies('creator_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return true;
    }

    public function rules()
    {
        return [
            'ids'   => 'required|array',
            'ids.*' => 'exists:creators,id',
        ];
    }
}
