<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyPrintfarmplanRequest;
use App\Http\Requests\StorePrintfarmplanRequest;
use App\Http\Requests\UpdatePrintfarmplanRequest;
use App\Models\Creator;
use App\Models\Printfarmplan;
use App\Models\Producttype;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class PrintfarmplanController extends Controller
{
    public function index(Request $request)
    {
        abort_if(Gate::denies('printfarmplan_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Printfarmplan::with(['productline', 'creator'])->select(sprintf('%s.*', (new Printfarmplan)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'printfarmplan_show';
                $editGate      = 'printfarmplan_edit';
                $deleteGate    = 'printfarmplan_delete';
                $crudRoutePart = 'printfarmplans';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('id', function ($row) {
                return $row->id ? $row->id : '';
            });
            $table->editColumn('name', function ($row) {
                return $row->name ? $row->name : '';
            });
            $table->addColumn('productline_name', function ($row) {
                return $row->productline ? $row->productline->name : '';
            });

            $table->addColumn('creator_name', function ($row) {
                return $row->creator ? $row->creator->name : '';
            });

            $table->rawColumns(['actions', 'placeholder', 'productline', 'creator']);

            return $table->make(true);
        }

        return view('admin.printfarmplans.index');
    }

    public function create()
    {
        abort_if(Gate::denies('printfarmplan_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $productlines = Producttype::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $creators = Creator::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.printfarmplans.create', compact('creators', 'productlines'));
    }

    public function store(StorePrintfarmplanRequest $request)
    {
        $printfarmplan = Printfarmplan::create($request->all());

        return redirect()->route('admin.printfarmplans.index');
    }

    public function edit(Printfarmplan $printfarmplan)
    {
        abort_if(Gate::denies('printfarmplan_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $productlines = Producttype::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $creators = Creator::pluck('name', 'id')->prepend(trans('global.pleaseSelect'), '');

        $printfarmplan->load('productline', 'creator');

        return view('admin.printfarmplans.edit', compact('creators', 'printfarmplan', 'productlines'));
    }

    public function update(UpdatePrintfarmplanRequest $request, Printfarmplan $printfarmplan)
    {
        $printfarmplan->update($request->all());

        return redirect()->route('admin.printfarmplans.index');
    }

    public function show(Printfarmplan $printfarmplan)
    {
        abort_if(Gate::denies('printfarmplan_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $printfarmplan->load('productline', 'creator');

        return view('admin.printfarmplans.show', compact('printfarmplan'));
    }

    public function destroy(Printfarmplan $printfarmplan)
    {
        abort_if(Gate::denies('printfarmplan_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $printfarmplan->delete();

        return back();
    }

    public function massDestroy(MassDestroyPrintfarmplanRequest $request)
    {
        $printfarmplans = Printfarmplan::find(request('ids'));

        foreach ($printfarmplans as $printfarmplan) {
            $printfarmplan->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
