<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyModelTypeRequest;
use App\Http\Requests\StoreModelTypeRequest;
use App\Http\Requests\UpdateModelTypeRequest;
use App\Models\ModelType;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ModelTypesController extends Controller
{
    public function index()
    {
        abort_if(Gate::denies('model_type_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $modelTypes = ModelType::all();

        return view('admin.modelTypes.index', compact('modelTypes'));
    }

    public function create()
    {
        abort_if(Gate::denies('model_type_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.modelTypes.create');
    }

    public function store(StoreModelTypeRequest $request)
    {
        $modelType = ModelType::create($request->all());

        return redirect()->route('admin.model-types.index');
    }

    public function edit(ModelType $modelType)
    {
        abort_if(Gate::denies('model_type_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.modelTypes.edit', compact('modelType'));
    }

    public function update(UpdateModelTypeRequest $request, ModelType $modelType)
    {
        $modelType->update($request->all());

        return redirect()->route('admin.model-types.index');
    }

    public function show(ModelType $modelType)
    {
        abort_if(Gate::denies('model_type_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        return view('admin.modelTypes.show', compact('modelType'));
    }

    public function destroy(ModelType $modelType)
    {
        abort_if(Gate::denies('model_type_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $modelType->delete();

        return back();
    }

    public function massDestroy(MassDestroyModelTypeRequest $request)
    {
        $modelTypes = ModelType::find(request('ids'));

        foreach ($modelTypes as $modelType) {
            $modelType->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
