<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Http\Requests\MassDestroyEventslogRequest;
use App\Http\Requests\StoreEventslogRequest;
use App\Http\Requests\UpdateEventslogRequest;
use App\Models\Event;
use App\Models\Eventslog;
use Gate;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Yajra\DataTables\Facades\DataTables;

class EventslogController extends Controller
{
    public function index(Request $request)
    {
        abort_if(Gate::denies('eventslog_access'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        if ($request->ajax()) {
            $query = Eventslog::with(['eventname'])->select(sprintf('%s.*', (new Eventslog)->table));
            $table = Datatables::of($query);

            $table->addColumn('placeholder', '&nbsp;');
            $table->addColumn('actions', '&nbsp;');

            $table->editColumn('actions', function ($row) {
                $viewGate      = 'eventslog_show';
                $editGate      = 'eventslog_edit';
                $deleteGate    = 'eventslog_delete';
                $crudRoutePart = 'eventslogs';

                return view('partials.datatablesActions', compact(
                    'viewGate',
                    'editGate',
                    'deleteGate',
                    'crudRoutePart',
                    'row'
                ));
            });

            $table->editColumn('id', function ($row) {
                return $row->id ? $row->id : '';
            });
            $table->addColumn('eventname_eventname', function ($row) {
                return $row->eventname ? $row->eventname->eventname : '';
            });

            $table->editColumn('cashtakings', function ($row) {
                return $row->cashtakings ? $row->cashtakings : '';
            });
            $table->editColumn('cardtakings', function ($row) {
                return $row->cardtakings ? $row->cardtakings : '';
            });

            $table->rawColumns(['actions', 'placeholder', 'eventname']);

            return $table->make(true);
        }

        return view('admin.eventslogs.index');
    }

    public function create()
    {
        abort_if(Gate::denies('eventslog_create'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $eventnames = Event::pluck('eventname', 'id')->prepend(trans('global.pleaseSelect'), '');

        return view('admin.eventslogs.create', compact('eventnames'));
    }

    public function store(StoreEventslogRequest $request)
    {
        $eventslog = Eventslog::create($request->all());

        return redirect()->route('admin.eventslogs.index');
    }

    public function edit(Eventslog $eventslog)
    {
        abort_if(Gate::denies('eventslog_edit'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $eventnames = Event::pluck('eventname', 'id')->prepend(trans('global.pleaseSelect'), '');

        $eventslog->load('eventname');

        return view('admin.eventslogs.edit', compact('eventnames', 'eventslog'));
    }

    public function update(UpdateEventslogRequest $request, Eventslog $eventslog)
    {
        $eventslog->update($request->all());

        return redirect()->route('admin.eventslogs.index');
    }

    public function show(Eventslog $eventslog)
    {
        abort_if(Gate::denies('eventslog_show'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $eventslog->load('eventname');

        return view('admin.eventslogs.show', compact('eventslog'));
    }

    public function destroy(Eventslog $eventslog)
    {
        abort_if(Gate::denies('eventslog_delete'), Response::HTTP_FORBIDDEN, '403 Forbidden');

        $eventslog->delete();

        return back();
    }

    public function massDestroy(MassDestroyEventslogRequest $request)
    {
        $eventslogs = Eventslog::find(request('ids'));

        foreach ($eventslogs as $eventslog) {
            $eventslog->delete();
        }

        return response(null, Response::HTTP_NO_CONTENT);
    }
}
